unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, System.ComponentModel, Borland.Vcl.StdCtrls,
  System.Text, Borland.Vcl.AppEvnts,
  Unit2;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    ApplicationEvents1: TApplicationEvents;
    procedure ApplicationEvents1Message(var Msg: tagMSG; var Handled: Boolean);
    procedure FormCreate(Sender: TObject);
  private
    polozenieMyszy :TPoint;
    ignorujRuchMyszki :Boolean;
    procedure Pisz(tekst :String);
  public
    procedure PodepnijOkno(oknoPodgladu :hWnd);
  end;

var
  Form1: TForm1;

implementation

{$R *.nfm}

procedure TForm1.Pisz(tekst :String);
begin
Memo1.Lines.Add(tekst);
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  {$IF NOT DEFINIED(CLR)}
  t :array[0..127] of Char;
  {$ELSE}
  t :StringBuilder;
  {$IFEND}
  dlg :Cardinal;
  ver :TOSVersionInfo;
  i :Integer;
  //czytanie ustawien
  czcionka :TFont;
  kolorTla :TColor;
begin
polozenieMyszy:=Mouse.CursorPos;
ShowCursor(False);

Pisz('');
for i:=0 to ParamCount do Pisz('Parameter '+IntToStr(i)+': '+ParamStr(i));

//czytanie ustawien
czcionka:=TFont.Create;
CzytajZRejestru(kolorTla,czcionka,ignorujRuchMyszki);
Memo1.Font.Assign(czcionka);
Memo1.Color:=kolorTla;
Pisz('');
Pisz('Font: '+Memo1.Font.Name+', '+IntToStr(Memo1.Font.Size));
Pisz('Colors/RGB: '+IntToHex(Memo1.Font.Color,6)+', '+IntToHex(Memo1.Color,6));

ShowWindow(Application.Handle,SW_HIDE);
SetWindowPos(Handle,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE);

Pisz('');
{$IF NOT DEFINIED(CLR)}
dlg:=Length(t);GetUserName(t,dlg);Pisz('User name: '+t);
dlg:=Length(t);GetComputerName(t,dlg);Pisz('Computer name: '+t);
dlg:=Length(t);GetWindowsDirectory(t,dlg);Pisz('Windows directory: '+t);
dlg:=Length(t);GetSystemDirectory(t,dlg);Pisz('System directory: '+t);
{$ELSE}
t:=StringBuilder.Create(128);
dlg:=t.Capacity;GetUserName(t,dlg);Pisz('User name: '+t.ToString);
dlg:=t.Capacity;GetComputerName(t,dlg);Pisz('Computer name: '+t.ToString);
dlg:=t.Capacity;GetWindowsDirectory(t,dlg);Pisz('Windows directory: '+t.ToString);
dlg:=t.Capacity;GetSystemDirectory(t,dlg);Pisz('System directory: '+t.ToString);
{$IFEND}

//Funkcja GetVersionEx nie dziala dobrze w .NET
ver.dwOSVersionInfoSize:=SizeOf(ver);
GetVersionEx(ver);
Pisz('Windows version: '+
     IntToStr(ver.dwMajorVersion)+'.'+
     IntToStr(ver.dwMinorVersion)+'.'+
     IntToStr(ver.dwBuildNumber)+', '+
     ver.szCSDVersion);

Pisz('Processor: '+GetEnvironmentVariable('PROCESSOR_IDENTIFIER'));
Pisz('');
end;

procedure TForm1.ApplicationEvents1Message(var Msg: tagMSG;
  var Handled: Boolean);
const czuloscMyszy=10;
var
  tekst,opis :String;
  {$IF NOT DEFINIED(CLR)} //Win32
  tytul,klasa :array[0..127] of Char;
  {$ELSE} //.NET
  tytul,klasa :StringBuilder;
  {$IFEND}
  nowePolozenieMyszy :TPoint;
begin
tekst:=DateTimeToStr(Now)+'/'+IntToStr(Msg.time)+': $'+IntToHex(Msg.message,4);

opis:='';
case Msg.message of
  WM_MOUSEMOVE:
    begin
    opis:='WM_MOUSEMOVE';
    nowePolozenieMyszy.X:=LOWORD(Msg.lParam);
    nowePolozenieMyszy.Y:=HIWORD(Msg.lParam);
    if not ignorujRuchMyszki then
    if (Abs(polozenieMyszy.X-nowePolozenieMyszy.X)>czuloscMyszy) or
       (Abs(polozenieMyszy.X-nowePolozenieMyszy.X)>czuloscMyszy) then Close;
    polozenieMyszy:=nowePolozenieMyszy;
    end;

  WM_RBUTTONDOWN,
  WM_LBUTTONDOWN,
  WM_KEYDOWN,
  WM_SYSKEYDOWN :Close;

  WM_MBUTTONDOWN: opis:='WM_MBUTTONDOWN';
  WM_MBUTTONUP: opis:='WM_MBUTTONUP';
  WM_MBUTTONDBLCLK: opis:='WM_MBUTTONDBLCLK';
  WM_MOUSEWHEEL: opis:='WM_MOUSEWHEEL';

  WM_ACTIVATE: opis:='WM_ACTIVATE';
  WM_PAINT: opis:='WM_PAINT';
  WM_POWER: opis:='WM_POWER';
  WM_POWERBROADCAST: opis:='WM_POWERBROADCAST';
  WM_QUERYENDSESSION: opis:='WM_QUERYENDSESSION';
  WM_COMMAND: opis:='WM_COMMAND';
  WM_SYSCOMMAND: opis:='WM_SYSCOMMAND';
  WM_ACTIVATEAPP: opis:='WM_ACTIVATEAPP';
  WM_DEVICECHANGE: opis:='WM_DEVICECHANGE';
  WM_DRAWITEM: opis:='WM_DRAWITEM';
  end;

if opis<>'' then tekst:=tekst+'/'+opis;
{$IF NOT DEFINIED(CLR)} //Win32
GetWindowText(Msg.hwnd,tytul,Length(tytul));
if Msg.hwnd=Memo1.Handle then StrCopy(tytul,'-----');
GetClassName(Msg.hwnd,klasa,Length(klasa));
tekst:=tekst+'   '+tytul+'/'+klasa+'/'+IntToStr(Msg.hwnd)+', '+IntToStr(LOWORD(Msg.lParam))+', '+IntToStr(HIWORD(Msg.lParam))+', '+IntToStr(Msg.wParam);
{$ELSE} //.NET
tytul:=StringBuilder.Create(128);
GetWindowText(Msg.hwnd,tytul,tytul.Capacity);
if Msg.hwnd=Memo1.Handle then
  begin
  tytul.Remove(0,tytul.Length);
  tytul.Append('-----');
  end;
klasa:=StringBuilder.Create(128);
GetClassName(Msg.hwnd,klasa,klasa.Capacity);
tekst:=tekst+'   '+tytul.ToString+'/'+klasa.ToString+'/'+IntToStr(Msg.hwnd)+', '+IntToStr(LOWORD(Msg.lParam))+', '+IntToStr(HIWORD(Msg.lParam))+', '+IntToStr(Msg.wParam);
{$IFEND}
//if Msg.message<>280 then
Pisz(tekst);
end;

procedure TForm1.PodepnijOkno(oknoPodgladu :hWnd);
var obszar :TRect;
begin
ShowCursor(True);
Memo1.Font.Size:=1;

//Ustalanie wasnoci okna aplikacji (normalnie ukrytego)
SetWindowLong(Application.Handle,
              GWL_EXSTYLE,
              WS_EX_TOOLWINDOW and not WS_EX_APPWINDOW or WS_EX_TOPMOST);

//Ustalanie wasnoci Form1
//GWL_STYLE - sygnalizuje zmiane stylu okna
//GWL_EXSTYLE - sygnalizuje zmiane rozszerzonego stylu okna
//WS_DISABLED - okno nie przyjmuje informacji od uzytkownika
//WS_CHILD - okno-dziecko, osadzone wewnatrz innego okna
SetWindowLong(Handle,
              GWL_STYLE,
              GetWindowLong(oknoPodgladu,GWL_STYLE) or WS_DISABLED or WS_CHILD);
SetWindowLong(Handle,
              GWL_EXSTYLE,
              GetWindowLong((oknoPodgladu),GWL_EXSTYLE));
Windows.SetParent(Handle,oknoPodgladu);

GetWindowRect(oknoPodgladu,obszar);
Width:=obszar.Right-obszar.Left;
Height:=obszar.Bottom-obszar.Top;
end;

end.
